<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Pie Chart with Index Labels Placed Inside</h1>
<div id="chartContainer"></div>

<?php
    $dataPoints = array( 
        array("label"=>"Industrial", "y"=>51.7),
        array("label"=>"Transportation", "y"=>26.6),
        array("label"=>"Residential", "y"=>13.9),
        array("label"=>"Commercial", "y"=>7.8)
    )
?>

<script>
    window.onload = function() {
        var chart = new CanvasJS.Chart("chartContainer", {
            theme: "light2",
            animationEnabled: true,
            title: {
                text: "World Energy Consumption by Sector - 2012"
            },
            data: [{
                type: "pie",
                indexLabel: "{y}",
                yValueFormatString: "#,##0.00\"%\"",
                indexLabelPlacement: "inside",
                indexLabelFontColor: "#36454F",
                indexLabelFontSize: 18,
                indexLabelFontWeight: "bolder",
                showInLegend: true,
                legendText: "{label}",
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }]
        });
        chart.render();
    }
</script>

<?php include '../footer.php'; ?>